unit IWWAPControls;
{PUBDIST}

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.Drawing,IWNETBaseControl,
  {$ENDIF}
  Classes,
  IWBaseControl, IWControlWAP, IWWAPTag,
  IWBaseInterfaces, IWWAPRenderContext;

type
  TIWLinkBaseWAP = class(TIWCustomControlWAP)
  protected
    procedure InitControl; override;
    {$IFDEF VSNET}
    function getText: string; reintroduce;virtual;
    procedure setText(AValue: string); reintroduce;virtual;
    {$ENDIF}
  public
    {$IFDEF VSNET}
    property Text: string read getText write setText;
    {$ENDIF}
  published
    property Enabled;

//    property ExtraTagParams;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWHyperLinkWAP.bmp}
  TIWHyperLinkWAP = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWHyperLinkWAP), 'TIWHyperLinkWAP.bmp')]
  {$ENDIF}
  TIWHyperLinkWAP = class(TIWLinkBaseWAP, IIWSubmitControl)
  protected
    FSubmitParam : String;
    procedure Submit(const AValue: string); override;
  public
    function RenderWap(AContext: TIWBaseWAPComponentContext): TIWWAPTag; override;
    function GetSubmitParam : String;
  published
    property OnClick;
    {$IFDEF VSNET}
    property Text;
    {$ELSE}
    property Caption;
    {$ENDIF}

  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.IntraWeb.TIWLinkWAP.bmp}
  TIWLinkWAP = class;
  [ToolboxItem(true), ToolBoxBitmap(typeof(TIWLinkWAP), 'TIWLinkWAP.bmp')]
  {$ENDIF}
  TIWLinkWAP = class(TIWLinkBaseWAP, IIWSubmitControl)
  protected
    FSubmitParam: string;
    procedure Submit(const AValue: string); override;
  public
    function RenderWAP(AContext: TIWBaseWAPComponentContext): TIWWAPTag; override;
    function GetSubmitParam: string;

  published
    property OnClick;
    {$IFDEF VSNET}
    property Text;
    {$ELSE}
    property Caption;
    {$ENDIF}

  end;


  TIWCustomURLWAP = class(TIWLinkBaseWAP)
  protected
    FTerminateApp: boolean;
    FURL: string;
    //
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property URL: string read FURL write FURL;
  protected
    procedure InitControl; override;
  public
    function RenderWap(AContext: TIWBaseWAPComponentContext): TIWWAPTag; override;
  published

    property TerminateApp: boolean read FTerminateApp write FTerminateApp;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWURLWAP.bmp}
  TIWURLWAP = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWURLWAP), 'TIWURLWAP.bmp')]
  {$ENDIF}
  TIWURLWAP = class(TIWCustomURLWAP)
  published
    property URL;
    {$IFDEF VSNET}
    property Text;
    {$ELSE}
    property Caption;
    {$ENDIF}

  end;

implementation

uses
  SysUtils,
  {$IFNDEF VSNET}
  {$IFDEF Linux}QForms, {$ELSE}Forms,{$ENDIF}
  {$ENDIF}
  IWCompLabelWAP, IWBaseForm, IWGlobal, IWServerControllerBase, IWTypes,
  IWBaseWAPControl, IWMarkupLanguageTag;

{ TIWLinkBaseWAP }

{$IFDEF VSNET}
function TIWLinkBaseWAP.getText: string;
begin
  Result := Caption;
end;

procedure TIWLinkBaseWAP.setText(AValue: string);
begin
  Caption := AValue;
  TIWNETBaseControl(Self).Invalidate;
end;
{$ENDIF}

procedure TIWLinkBaseWAP.InitControl;
begin
  inherited;
  Width := 65;
  Height := 17;
end;

{ TIWHyperLinkWAP }

function TIWHyperLinkWAP.GetSubmitParam: String;
begin
  Result := FSubmitParam;
end;

function TIWHyperLinkWAP.RenderWap(AContext: TIWBaseWAPComponentContext): TIWWAPTag;
var
  LLabel: TIWLabelWAP;
  LAction: string;
  LForm: TIWBaseForm;
  LAmp: string;
begin
  LAmp := '&amp;';
  if Enabled then begin
    Result := TIWWAPTag.CreateTag('a'); try
      LForm := TIWBaseForm(AContext.WebApplication.ActiveForm);
      LAction := LForm.FormAction;
      if GServerController.SessionTrackingMethod in [tmHidden] then begin
        Result.AddStringParam('href', LAction + '/call?' + ComponentName
          + LAmp + 'IW_FormName=' + LForm.Name
          + LAmp + 'IW_FormClass=' + LForm.ClassName
          + '/' + IntToStr(AContext.WebApplication.TrackId) + '/' + AContext.WebApplication.AppID);
      end else begin
        Result.AddStringParam('href', LAction + '/call?' + ComponentName + LAmp + 'IW_FormName=' + LForm.Name
          + LAmp + 'IW_FormClass=' + LForm.ClassName);

      end;
      if AContext.PageContext.OutputTagType = wotWML then begin
        Result.Contents.AddText(TextToWML(Caption));
      end else begin
        Result.Contents.AddText(TextToXHTMLMP(Caption));
      end;
    except FreeAndNil(Result); raise; end;
  end else begin
    LLabel := TIWLabelWAP.Create{$IFNDEF VSNET}(Self){$ENDIF}; try
      LLabel.Name := Name;
//        LLabel.RawText := FRawText;
      if AContext.PageContext.OutputTagType = wotWML then begin
        LLabel.Caption := TextToWML(Caption);
      end else begin
        LLabel.Caption := TextToXHTMLMP(Caption);
      end;
      LLabel.Width := Width;
      LLabel.Height := Height;
      LLabel.Visible := true;
      Result := LLabel.RenderWap(AContext);
    finally FreeAndNil(LLabel); end;
  end;
end;

procedure TIWHyperLinkWAP.Submit(const AValue: string);
begin
  FSubmitParam := AValue;
  DoClick;
end;

{ TIWCustomURLWAP }

procedure TIWCustomURLWAP.InitControl;
begin
  inherited;
  FURL := '';
end;

function TIWCustomURLWAP.RenderWap(AContext: TIWBaseWAPComponentContext): TIWWAPTag;
var
  LURL: string;
begin
  {if AContext.PageContext.OutputTagType = wotWML then }begin
    if Enabled then begin
      Result := TIWWAPTag.CreateTag('a');
      try
        if TerminateApp then begin
          LURL := FURL;
          if AnsiSameText(Copy(LURL, 1, 7), 'http://') then begin
            Delete(LURL, 1, 7);
          end else if AnsiSameText(Copy(LURL, 1, 8), 'https://') then begin
            Delete(LURL, 1, 8);
            LURL := '_s_.' + LURL;
          end;
          Result.AddStringParam('href', '/STOP/' + AContext.WebApplication.AppID + '/' + LURL);
        end else begin
          Result.AddStringParam('href', FURL);
        end;
        Result.Contents.AddText(TextToWML(Caption));
      except
        FreeAndNil(Result);
        raise;
      end;
    end;
  end;
end;

procedure TIWLinkWAP.Submit(const AValue: string);
begin
  FSubmitParam := AValue;
  DoClick;
end;

function TIWLinkWAP.RenderWAP(AContext: TIWBaseWAPComponentContext): TIWWAPTag;
var
  LLabel: TIWLabelWAP;
  LAction: string;
  LForm: TIWBaseForm;
  LGo: TIWWAPTag;
  LPOstTag: TIWWAPTag;
begin
  if Enabled then begin
    if AContext.PageContext.OutputTagType = wotWML then begin
      Result := TIWWAPTag.CreateTag('anchor');
      try
        Result.AddStringParam('title', Caption);
        Result.Contents.AddText(TextToWML(Caption));
        LForm := TIWBaseForm(AContext.WebApplication.ActiveForm);
        LAction := LForm.FormAction;
        LGo := TIWWAPTag.CreateTag('go');
        if GServerController.CharSet <> '' then begin
          LGo.AddStringPAram('accept-charset', GServerController.CharSet);
        end;
        LGo.AddStringParam('href', LAction + '/' + IntToStr(AContext.WebApplication.TrackId) + '/' + AContext.WebApplication.AppID);
        LGo.AddStringParam('method', 'post');
        LPostTag := TIWWAPTag.CreateWAPTag('postfield', cbSimpleClose);
        with LPostTag do begin
          AddStringParam('name', 'IW_Action');
          AddStringParam('value', ComponentName);
        end;
        LGo.Contents.AddTagAsObject(LPostTag);
        LPostTag := TIWWAPTag.CreateWAPTag('postfield', cbSimpleClose);
        with LPostTag do begin
          AddStringParam('name', 'IW_FormName');
          if Self.Name = '' then begin
            Self.Name := 'noname';
          end;
          AddStringParam('value', LForm.Name);
        end;
        LGo.Contents.AddTagAsObject(LPostTag);
        LPostTag := TIWWAPTag.CreateWAPTag('postfield', cbSimpleClose);
        with LPostTag do begin
          AddStringParam('name', 'IW_FormClass');
          {$IFDEF VSNET}
          AddStringParam('value', self.GetType.FullName);
          {$ELSE}
          AddStringParam('value', LForm.ClassName);
          {$ENDIF}
        end;
        LGo.Contents.AddTagAsObject(LPostTag);

        AddSessionFields(LGo,AContext);

        LGo.Contents.AddText('{$FORMTAG$}');
        Result.Contents.AddTagAsObject(LGo);
      except
        FreeAndNil(Result);
        raise;
      end;
    // We don't support JS in XHTML MP that's why we render as HyperLink
    end else begin
      Result := TIWWAPTag.CreateTag('a'); try
        LForm := TIWBaseForm(AContext.WebApplication.ActiveForm);
        LAction := LForm.FormAction;
        if GServerController.SessionTrackingMethod in [tmHidden] then begin
          Result.AddStringParam('href', LAction + '/call?' + ComponentName
            + '&IW_FormName=' + LForm.Name
            + '&IW_FormClass=' + LForm.ClassName
            + '/' + IntToStr(AContext.WebApplication.TrackId) + '/' + AContext.WebApplication.AppID);
        end else begin
          Result.AddStringParam('href', LAction + '/call?' + ComponentName + '&IW_FormName=' + LForm.Name
             + '&IW_FormClass=' + LForm.ClassName);
        end;
        Result.Contents.AddText(TextToXHTMLMP(Caption));
      except FreeAndNil(Result); raise; end;
    end;
  end else begin
    LLabel := TIWLabelWAP.Create{$IFNDEF VSNET}(Self){$ENDIF}; try
      LLabel.Name := Name;
//        LLabel.RawText := FRawText;

       if AContext.PageContext.OutputTagType = wotWML then begin
        LLabel.Caption := TextToWML(Caption);
      end else begin
        LLabel.Caption := TextToXHTMLMP(Caption);
      end;
       LLabel.Width := Width;
      LLabel.Height := Height;
      LLabel.Visible := true;
      Result := LLabel.RenderWap(AContext);
    finally FreeAndNil(LLabel); end;
  end;
end;

function TIWLinkWAP.GetSubmitParam: string;
begin
  Result := FSubmitParam;
end;

end.

